@echo off

net session >nul 2>&1
if %errorLevel% NEQ 0 (
    echo ERROR: Administrative permission is required.
    echo Please run the setup script as administrator.
    pause >nul
    exit /b -1
)

call :TryInstall "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\JavaSoft\Java Runtime Environment"
if %errorLevel% EQU 0 goto :EOF
call :TryInstall "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\JavaSoft\Java Development Kit"
if %errorLevel% EQU 0 goto :EOF
call :TryInstall "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\JavaSoft\JDK"
if %errorLevel% EQU 0 goto :EOF
call :TryInstall "HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Runtime Environment"
if %errorLevel% EQU 0 goto :EOF
call :TryInstall "HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Development Kit"
if %errorLevel% EQU 0 goto :EOF
call :TryInstall "HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\JDK"
if %errorLevel% NEQ 0 (
    echo ERROR: Could not find Java Runtime Environment on your system. 
    echo Please install Java 1.8 or higher and run the setup script again.
    pause
    start "" "https://www.java.com/en/download/"
    exit /b -1
)
exit /b 0


@rem param1=[in]registryKey
:TryInstall
    @rem Step1: Check Java version.
    set regKey=%~1
    call :GetRegValue "%regKey%" "CurrentVersion" regValue
    if %errorLevel% NEQ 0 (
        exit /b -1
    )
    set javaVersion=%regValue%
    for /f "tokens=1,2 delims=." %%a in ("%javaVersion%") do (
        set /a javaMajorVersion=%%a
        set /a javaMinorVersion=%%b
    )
    set isJavaCompatible=0
    if %javaMajorVersion% EQU 1 (
        @rem Eg. 1.8.0
        if %javaMinorVersion% GEQ 8 (
            set isJavaCompatible=1
        )
    ) else (
        @rem Eg. 11.0.7
        if %javaMajorVersion% GEQ 8 (
            set isJavaCompatible=1
        )
    )
    if %isJavaCompatible% EQU 0 (
        exit /b -1
    )
    
    @rem Step2: Check if java executable exists.
    call :GetRegValue "%regKey%\%javaVersion%" "JavaHome" regValue
    if %errorLevel% NEQ 0 (
        exit /b -1
    )
    set javaHome=%regValue%
    echo Java home: %javaHome%
    set javaExe="%javaHome%\bin\java.exe"
    if NOT exist %javaExe% (
        echo ERROR: %javaExe% does not exist.
        exit /b -1
    )

    @rem Step3: Being installation.
    %javaExe% -jar "%~dp0bin/installer.jar" "QNAP vSphere Client Plugin v5.0.3.2"
    exit /b 0


@rem param1=[in]key, param2=[in]name, param3=[out]value
:GetRegValue
    set cmd=reg query "%~1" /v "%~2"
    %cmd% >nul 2>&1
    if %errorLevel% NEQ 0 (
        exit /b -1
    )
    for /f "usebackq skip=2 tokens=1,2*" %%a in (`"%cmd%"`) do (
        set %~3=%%c
    )
    exit /b 0
