/*
 * Decompiled with CFR 0.152.
 */
package com.qnap.installer;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class Application {
    public static void main(String[] args) throws Exception {
        Application application = new Application(args);
        application.run();
        System.exit(0);
    }

    private Application(String[] args) {
        if (args.length != 1) {
            System.err.println("Please run the installer via 'setup.cmd'.");
            System.exit(-1);
        }
        System.out.println("Product name: " + args[0]);
    }

    private void run() throws Exception {
        Path workingDir = Files.createTempDirectory(this.getClass().getPackage().getName(), new FileAttribute[0]);
        Path nsisInstaller = Paths.get(workingDir.toString(), "installer.exe");
        try (InputStream data = this.getClass().getClassLoader().getResourceAsStream("data");){
            assert (data != null);
            Files.copy(data, nsisInstaller, StandardCopyOption.REPLACE_EXISTING);
        }
        Process process = Runtime.getRuntime().exec(nsisInstaller.toString());
        process.waitFor();
        Files.delete(nsisInstaller);
        Files.delete(workingDir);
    }
}

